/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.api.VWOperationDefinition;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWOperationTableModel;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.table.VWQuickSort;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWToolTipTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.VWTitledBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public class VWOperationSelectionDialog
extends VWModalDialog
implements ActionListener,
ListSelectionListener {
    private int m_nStatus = 1;
    private VWAuthPropertyData m_authPropertyData = null;
    private JComboBox m_componentComboBox = null;
    private VWOperationTableModel m_operationsTableModel = null;
    private VWTable m_operationsTable = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;

    public VWOperationSelectionDialog(VWAuthPropertyData authPropertyData) {
        super(authPropertyData.getMainContainer());
        this.m_authPropertyData = authPropertyData;
        this.initialize();
    }

    public String getQueueName() {
        return (String)this.m_componentComboBox.getSelectedItem();
    }

    public VWOperationDefinition[] getSelectedOperations() {
        int[] nRows = this.m_operationsTable.getSelectedRows();
        if (nRows.length > 0) {
            VWOperationDefinition[] vwOperationDefs = new VWOperationDefinition[nRows.length];
            for (int i = 0; i < nRows.length; ++i) {
                vwOperationDefs[i] = this.m_operationsTableModel.getItemAt(nRows[i]);
            }
            return vwOperationDefs;
        }
        return null;
    }

    public int getStatus() {
        return this.m_nStatus;
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object.equals(this.m_componentComboBox)) {
            this.initOperationsTable((String)this.m_componentComboBox.getSelectedItem());
        } else if (object.equals(this.m_okButton)) {
            this.m_nStatus = 0;
            this.setVisible(false);
        } else if (object.equals(this.m_cancelButton)) {
            this.m_nStatus = 1;
            this.setVisible(false);
        } else if (object.equals(this.m_helpButton)) {
            VWHelp.displayPage(VWHelp.Help_Process_Designer + "bpfdh151.htm");
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        if (event.getSource().equals(this.m_operationsTable.getSelectionModel())) {
            this.m_okButton.setEnabled(event.getFirstIndex() != -1);
        }
    }

    private void initialize() {
        try {
            Dimension dim = VWStringUtils.stringToDimension("555,335");
            if (dim == null) {
                dim = new Dimension(500, 300);
            }
            this.setSize(dim);
            this.setTitle(VWResource.s_operationSelectionDlgTitle);
            this.setVisible(false);
            this.getContentPane().setLayout(new BorderLayout(10, 10));
            this.getContentPane().add((Component)this.getTopPanel(), "First");
            this.getContentPane().add((Component)this.getMainPanel(), "Center");
            this.getContentPane().add((Component)this.getButtonPanel(), "Last");
            this.initComponentComboBox();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getTopPanel() {
        try {
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.insets = new Insets(4, 4, 4, 4);
            gbCons.gridwidth = 1;
            gbCons.anchor = 21;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            panel.add((Component)new JLabel(VWResource.s_component), gbCons);
            gbCons.gridwidth = 2;
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_componentComboBox = new JComboBox();
            this.m_componentComboBox.addActionListener(this);
            panel.add((Component)this.m_componentComboBox, gbCons);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getMainPanel() {
        try {
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(new VWTitledBorder(VWResource.s_operations));
            this.m_operationsTableModel = new VWOperationTableModel();
            this.m_operationsTable = new VWTable(this.m_operationsTableModel);
            this.m_operationsTable.getSelectionModel().addListSelectionListener(this);
            TableColumn tcElement = this.m_operationsTable.getColumn(this.m_operationsTableModel.getColumnName(1));
            if (tcElement != null) {
                tcElement.setCellRenderer(new VWToolTipTableCellRenderer());
            }
            panel.add((Component)new JScrollPane(this.m_operationsTable), "Center");
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getButtonPanel() {
        try {
            JPanel panel = new JPanel();
            panel.setLayout(new FlowLayout());
            this.m_okButton = new JButton(VWResource.s_ok);
            this.m_okButton.setDefaultCapable(true);
            this.m_okButton.addActionListener(this);
            panel.add(this.m_okButton);
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_cancelButton.addActionListener(this);
            panel.add(this.m_cancelButton);
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.addActionListener(this);
            panel.add(this.m_helpButton);
            this.getRootPane().setDefaultButton(this.m_okButton);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initComponentComboBox() {
        try {
            if (this.m_authPropertyData == null || this.m_authPropertyData.getVWSession() == null) {
                return;
            }
            this.m_componentComboBox.removeActionListener(this);
            Object[] queueNames = this.m_authPropertyData.getDesignerCoreData().getDataDictionary().getQueueNames(4);
            if (queueNames != null && queueNames.length > 0) {
                VWQuickSort sort = new VWQuickSort(queueNames, 0);
                sort.sort(0, queueNames.length - 1);
                DefaultComboBoxModel<Object> cbModel = new DefaultComboBoxModel<Object>(queueNames);
                this.m_componentComboBox.setModel(cbModel);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            this.m_componentComboBox.addActionListener(this);
            if (this.m_componentComboBox.getItemCount() > 0) {
                this.m_componentComboBox.setSelectedIndex(0);
            }
        }
    }

    private void initOperationsTable(String queueName) {
        try {
            if (this.m_authPropertyData == null || this.m_authPropertyData.getVWSession() == null) {
                return;
            }
            Object[] operations = null;
            VWQueueDefinition vwQueueDef = this.m_authPropertyData.getDesignerCoreData().getDataDictionary().getQueueDefinition(queueName);
            if (vwQueueDef != null && (operations = vwQueueDef.getOperations()) != null && operations.length > 0) {
                VWQuickSort sort = new VWQuickSort(operations, 0);
                sort.sort(0, operations.length - 1);
            }
            this.m_operationsTableModel.reinitialize((VWOperationDefinition[])operations);
            this.m_okButton.setEnabled(false);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

